package EXT.DOMAIN.pit.service;

import java.util.logging.Logger;

import EXT.DOMAIN.pit.database.VeteranProcedure;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import weblogic.logging.LoggingHelper;

import com.google.gson.Gson;

@Path("/veteran")
@Produces (MediaType.APPLICATION_JSON)
public class VeteranService {

	private static Gson gson = new Gson();
//	private VeteranProcedure vetProc = VeteranProcedure.getInstance();	//vadim
	private VeteranProcedure vetProc = null;			//vadim
	private final static Logger logger = LoggingHelper.getServerLogger();
	
	@GET
	@Path("/hello")
	public String getHello() {
		return gson.toJson("hello");
	}
	
	@POST
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	@Path("/add")
	public String addVeteran(@FormParam("surveyRecordID") String surveyRecordID, @FormParam("surveyDateTime") long surveyDateTime, 
			@FormParam("firstName") String firstName, @FormParam("middleName") String middleName, 
			@FormParam("lastName") String lastName, @FormParam("gender") String gender, @FormParam("age") int age, 
			@FormParam("deviceID") String deviceID, @FormParam("chronic") boolean chronic, 
			@FormParam("loc_Latitude") float loc_Latitude, @FormParam("loc_Longitude") float loc_Longitude, 
			@FormParam("loc_Accuracy") float loc_Accuracy, @FormParam("address") String address, @FormParam("city") String city, 
			@FormParam("state") String state) {
		
		logger.fine("\nSurveyRecordID: " + surveyRecordID +
    			"\nSurveyDateTime: " + surveyDateTime +
    			"\nFirstName: " + firstName +
    			"\nMiddleName: " + middleName +
    			"\nLastName: " + lastName +
    			"\nGender: " + gender +
    			"\nAge: " + age +
    			"\nDeviceID: " + deviceID +
    			"\nChronicallyHomeless: " + chronic +
    			"\nLoc_Latitude: " + loc_Latitude +
    			"\nLoc_Longitude: " + loc_Longitude +
    			"\nLoc_Accuracy: " + loc_Accuracy + 
    			"\nAddress: " + address +
    			"\nCity: " + city +
    			"\nState: " + state);
    	
		vetProc = new VeteranProcedure();			//vadim
		String response = vetProc.callProcedure(surveyRecordID, surveyDateTime, firstName, middleName, lastName, gender, age, 
				deviceID, chronic, loc_Latitude, loc_Longitude, loc_Accuracy, address, city, state);
		return gson.toJson(response);
	}
}
